#! CRADDON 1
#! NAME Maginot
#! DESCRIPTION Static and Static Split profiles for Coranto.<br>written by <a href="mailto:plushpuffin@wwddfd.com">plushpuffin</a><br><a href="http://www.wwddfd.com/">plushpuffin's perl garden</a>
#! VERSION build 10
#! DOC 1

#
# Provides static page and static split page functionality for Coranto.
# by plushpuffin
# plushpuffin@wwddfd.com
# http://www.wwddfd.com/
#

my $addon = new Addon('Maginot');
$addon->addProfileType('Maginot Static');
$addon->addProfileType('Maginot Static Split');
$addon->addProfileType('Maginot Sliced');
$addon->addProfileType('Maginot Sliced Index');
$addon->checkBuild(20);
$addon->registerAdminFunction( 'editprofileppstatic', 'EditProfilePPStatic' );
$addon->registerAdminFunction( 'editprofileppstaticsave', 'EditProfilePPStaticSave' );
$addon->addSortOrder( 'MaginotDefault', 'Unsorted (Reverse Chronological) for interlinking' );

$Subs{Maginot_LoadCustomFields} = << 'END_SUB';
sub Maginot_LoadCustomFields {
	return if( scalar keys %PPCustomFields );
	%PPCustomFields = (
		FirstLetter =>
		[
			q~Slice by first letter of Subject~,
			q~Sliced pages group news items by first letter of subject.~,
			q~A.html<br>B.html<br>C.html~,
			sub { return uc substr($Subject, 0, 1); }
		],
		LowerCaseSubject =>
		[
			q~Lowercase Subject~,
			q~Static/Sliced field will be the Subject in all lowercase.~,
			q~nocapshere.html<br>all_lowercase.html<br>hehehe.html~,
			sub { return lc $Subject; }
		],
		MonthYear =>
		[
			q~Month and Year~,
			q~Slice at the end of each month (like a monthly archive).~,
			q~January2002.html<br>February2002.html<br>March2002.html~,
			sub { return "$Month_Name$Year"; }
		],
		TenPerPage =>
		[
			q~Ten items per page~,
			q~Slice the profile's news so that ten news items are included on each page.~,
			q~arc0.html<br>arc1.html<br>arc2.html~,
			sub { return 'arc' . int(( $PPStaticOpts{$ProfileName}->{newsnum} - 1 )/10); }
		],
		index =>
		[
			qq~Name it index.$newsprofiles{$ProfileName}->{ppstaticfilext}~,
			qq~Put every item in this profile into a file called <b>index.[extension]</b>~,
			qq~index.$newsprofiles{$ProfileName}->{ppstaticfilext}~,
			sub { return 'index' }
		]
	);
}
END_SUB

$Subs{Maginot_KillChars} = << 'END_SUB';
sub Maginot_KillChars {
	$_ = $_[0];
	$_ =~ s/[^A-Za-z0-9\-\.]+//g;
	return $_;
}
END_SUB

$Subs{Maginot_MakePath} = << 'END_SUB';
use File::Path;
sub Maginot_MakePath {
	my $dirpath = $_[0];
	$dirpath =~ s~/[^/]+/\.\.~/~g;
	$dirpath =~ s/<TextField\: ([^\s\>\{\[]+)>/'%^' . HTMLtoText(${$1}) . '%%'/ge;
	$dirpath =~ s/<TextField\: ([^\s\>\{]+)\{[\'\"]([^\s\>\}\'\"]+)[\'\"]\}>/'%^' . HTMLtoText(${$1}{$2}) . '%%'/ge;
	$dirpath =~ s/<TextField\: ([^\s\>\[]+)\[(\d+)\]>/'%^' . HTMLtoText(${$1}[$2]) . '%%'/ge;
	$dirpath =~ s/<Field\: ([^\s\>\{\[]+)>/\%\^${$1}\%\%/g;
	$dirpath =~ s/<Field\: ([^\s\>\{]+)\{[\'\"]([^\s\>\}\'\"]+)[\'\"]\}>/\%\^${$1}{$2}\%\%/g;
	$dirpath =~ s/<Field\: ([^\s\>\[]+)\[(\d+)\]>/\%\^${$1}[$2]\%\%/g;
	$dirpath =~ s~/\.\.(/|\Z)~$1~g;		# no dot-dot allowed.
	$dirpath =~ s~/\.(/|\Z)~$1~g;		# just get rid of single-dot.
	$dirpath =~ s~[\"\<\>\?\\\*\|]~,~g;
	$dirpath =~ s~\%\^(.*?)\%\%~&Maginot_KillChars($1)~ge;
	mkpath($dirpath);
	return $dirpath;
}
END_SUB

$Subs{Maginot_GetPath} = << 'END_SUB';
sub Maginot_GetPath {
	my $dirpath = $_[0];
	$dirpath =~ s~/[^/]+/\.\.~/~g;
	$dirpath =~ s/<TextField\: ([^\s\>\{\[]+)>/'%^' . HTMLtoText(${$1}) . '%%'/ge;
	$dirpath =~ s/<TextField\: ([^\s\>\{]+)\{[\'\"]([^\s\>\}\'\"]+)[\'\"]\}>/'%^' . HTMLtoText(${$1}{$2}) . '%%'/ge;
	$dirpath =~ s/<TextField\: ([^\s\>\[]+)\[(\d+)\]>/'%^' . HTMLtoText(${$1}[$2]) . '%%'/ge;
	$dirpath =~ s/<Field\: ([^\s\>\{\[]+)>/\%\^${$1}\%\%/g;
	$dirpath =~ s/<Field\: ([^\s\>\{]+)\{[\'\"]([^\s\>\}\'\"]+)[\'\"]\}>/\%\^${$1}{$2}\%\%/g;
	$dirpath =~ s/<Field\: ([^\s\>\[]+)\[(\d+)\]>/\%\^${$1}[$2]\%\%/g;
	$dirpath =~ s~/\.\.(/|\Z)~$1~g;		# no dot-dot allowed.
	$dirpath =~ s~/\.(/|\Z)~$1~g;		# just get rid of single-dot.
	$dirpath =~ s~[\"\<\>\?\\\*\|]~,~g;
	$dirpath =~ s~\%\^(.*?)\%\%~&Maginot_KillChars($1)~ge;
	return $dirpath;
}
END_SUB

$Subs{'MaginotDefault'} = <<'END_SUB';
sub MaginotDefault {
	return @_;
}
END_SUB

# BuildNewsStatic: This handles building static profile news after Submit and Modify.
$Subs{BuildNewsStatic} = << 'END_SUB';
sub BuildNewsStatic {
	my $buildtype = shift;
	# Get initial data and initialize variables.

	my (%ActiveProfiles, %ProfCats, %ProfTimeFilter, %ProfFiltSub);
	my (%ProfArchiveFilePath, %ProfFilePath, %ProfType, $i, %ProfSkip);
	# Allows addons some easier variable access.
	sub GetBuildVar {
		my $name = shift;
		$name =~ s/(\S+)/'$' . $1/ee;
		return $name;
	}

	# If $buildtype == 1, then we must do a full rebuild.
	# HOOK: InitActiveProfiles
	if($Addons{'InitActiveProfiles'}){my $w;foreach $w (@{$Addons{'InitActiveProfiles'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
	INITLOOP: foreach $i (keys %newsprofiles) {
		# HOOK: InitActiveProfiles_UseProfile
		if($Addons{'InitActiveProfiles_UseProfile'}){my $w;foreach $w (@{$Addons{'InitActiveProfiles_UseProfile'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
		if ($newsprofiles{$i}->{'enabled'}) {
			$ActiveProfiles{$i} = 1;
			unless( $newsprofiles{$i}->{ppautorebuild} && scalar keys %ChangedItems && $newsprofiles{$i}->{type} =~ /\AMaginot Static/ ) {
				delete $ActiveProfiles{$i};
				next;
			}
			if ($EnableCategories) {
				$ProfCats{$i} = {};
				my $j;
				foreach $j (@{$newsprofiles{$i}->{'cats'}}) {
					$ProfCats{$i}->{$j} = 1;
				}
			}
			if ($newsprofiles{$i}->{'agefilter'}) {
				$ProfTimeFilter{$i} = (PastDaysTime($newsprofiles{$i}->{'agefilter'}))[0];
			}
			else {
				$ProfTimeFilter{$i} = 0;
			}
			$ProfFiltSub{$i} = $newsprofiles{$i}->{'filtsub'} if $newsprofiles{$i}->{'filtsub'};
			$ProfType{$i} = $newsprofiles{$i}->{'type'};
			if ($newsprofiles{$i}->{'filepath'}) {
				$ProfFilePath{$i} = $newsprofiles{$i}->{'filepath'};
			}
			else {
				$ProfFilePath{$i} = $CConfig{'htmlfile_path'};
			}
			$newsprofiles{$i}->{'LastBuildTime'} = $CurrentTime;
			# HOOK: InitActiveProfiles_2
			if($Addons{'InitActiveProfiles_2'}){my $w;foreach $w (@{$Addons{'InitActiveProfiles_2'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
		}
	}
	unless( $userfieldvarsloaded ) {
		InitUserFieldVars();
		$userfieldvarsloaded = 1;
	}
	if (keys %ActiveProfiles) {
		my (%FilteredContent);
		my ($line, $key, $value);
	
		# Addons: don't necessarily assume you're in Build News here; this hook may be duplicated
		# in other places where news is being built, after SplitDataFile has been run.
		# It's intended to be the place where you set the values of synthetic fields.
		# HOOK: Build_GetData
		if($Addons{'Build_GetData'}){my $w;foreach $w (@{$Addons{'Build_GetData'}}){my $addon=$w->[2];eval ${$w->[0]};AErr($addon,$@)if $@;};}
		
		# Go through each profile, one at a time.
		PROFLOOP: while ($i = each %ActiveProfiles) {
			unless( $newsprofiles{$i}->{ppautorebuild} && scalar keys %ChangedItems && (
$newsprofiles{$i}->{type} eq 'Maginot Static' || $newsprofiles{$i}->{type} eq 'Maginot Static Split'
) ) {
				delete $ActiveProfiles{$i};
				next;
			}
			# Filter by category.
			if (!$EnableCategories || $ProfCats{$i}->{'AllCategories'} || $ProfCats{$i}->{$Category}) {
				# Filter by age/number
				if ($newstime >= $ProfTimeFilter{$i}) {
					if ($ProfFiltSub{$i}) {
						my $tmpnhash = {};
						foreach $k (@fieldDB_internalorder) {
							$tmpnhash->{$k} = ${$k};
						}
						push(@{$FilteredContent{$i}}, $tmpnhash);
					}
					else {
						$ProfileName = $i;
						&Maginot_BuildStatic;
					}
				}
				else {
					# No news matches this profile. Delete it from the active list so that it will
					# be ignored in the future.
					delete $ActiveProfiles{$i};
					# If no profiles are left, stop building.
					unless (keys %ActiveProfiles) {
						last NCLOOP;
					}
				}
			}
		}
	}

	# Take care of profiles with other sort orders.
	foreach $i (keys %FilteredContent) {
		if ($newsprofiles{$i}->{'filtsub'}) {
			# Run the saved data through the specified sorting subroutine.
			my @FilteredND = &{$newsprofiles{$i}->{'filtsub'}}(@{$FilteredContent{$i}});
			foreach $j (@FilteredND) {
				# The data has been sorted; go through the sorted data.
				# Get the global field variables.
				foreach $k (keys %{$j}) {
					${$k} = $j->{$k};
				}
				
				# Build HTML, save. As usual.
				$Date = GetTheDate($newstime);
				$ProfileName = $i;
				$FileName = $i;
				&Maginot_BuildStatic;
			}
		}
	}

} # We're done!
END_SUB

#
# Initalize values for the static/sliced profiles to use later on.
#
$Subs{Maginot_InitActiveProfiles} = << 'END_SUB';
sub Maginot_InitActiveProfiles {
	&Maginot_LoadCustomFields;
	if( scalar keys %PPStaticOpts ) { return; }
	foreach my $prof (keys %newsprofiles) {
		unless ( $newsprofiles{$prof}->{enabled} ) { next; }
		if( $newsprofiles{$prof}->{'type'} eq 'Maginot Static' ) {
			$PPStaticOpts{$prof} = {
				staticfield => $newsprofiles{$prof}->{'ppstaticfield'} || 'newsid',
				maxlength => $newsprofiles{$prof}->{'ppstaticmaxfnlength'} || 26,
				filext => $newsprofiles{$prof}->{'ppstaticfilext'} || $CConfig{'ArcHtmlExt'},
				dirurl => $newsprofiles{$prof}->{'ppstaticdirurl'} || '',
				newsnum => 0,
				baseurl => $newsprofiles{$prof}->{'ppstaticbaseurl'} || '' };

		}
		elsif( $newsprofiles{$prof}->{type} eq 'Maginot Static Split' ) {
			my( @splitsubs, @splittmpl );
			push( @splitsubs, $newsprofiles{$prof}->{style} );
			push( @splittmpl, $newsprofiles{$prof}->{tmplfile} ) if( $newsprofiles{$prof}->{tmplfile} );
			@_ = split( /;*\s*;\s*;*/, $newsprofiles{$prof}->{ppsplittmpl} );
			foreach my $i (@_) {
				push( @splittmpl, $i ) if( $i );
			}
			@_ = split( /;*\s*;\s*;*/, $newsprofiles{$prof}->{ppsplitsubs} );
			foreach my $i (@_) {
				$i =~ s/[^a-z0-9_]//g;
				push( @splitsubs, qq~NewsStyle_$i~ ) if( $i );
			}
			$PPStaticOpts{$prof} = {
				staticfield => $newsprofiles{$prof}->{'ppstaticfield'} || 'newsid',
				maxlength => $newsprofiles{$prof}->{'ppstaticmaxfnlength'} || 26,
				filext => $newsprofiles{$prof}->{'ppstaticfilext'} || $CConfig{'ArcHtmlExt'},
				dirurl => $newsprofiles{$prof}->{'ppstaticdirurl'} || '',
				newsnum => 0,
				baseurl => $newsprofiles{$prof}->{'ppstaticbaseurl'} || '' };
			@{$PPStaticOpts{$prof}->{splittmpl}} = @splittmpl;
			@{$PPStaticOpts{$prof}->{splitsubs}} = @splitsubs;
		}
		elsif( $newsprofiles{$prof}->{type} =~ /\AMaginot Sliced/ ) {
			&Maginot_LoadCustomFields;
			$PPStaticOpts{$prof} = {
				SliceField => $newsprofiles{$prof}->{'ppstaticfield'} || 'Subject',
				maxlength => $newsprofiles{$prof}->{'ppstaticmaxfnlength'} || 26,
				filext => $newsprofiles{$prof}->{'ppstaticfilext'} || $CConfig{'ArcHtmlExt'},
				dirurl => $newsprofiles{$prof}->{'ppstaticdirurl'} || '',
				newsnum => 0,
				baseurl => $newsprofiles{$prof}->{'ppstaticbaseurl'} || ''};
		}
	}
}
END_SUB

my $InitActiveProfiles_2 = << 'END_CODE';
	if( ! $buildtype && $newsprofiles{$i}->{ppautorebuild} && ! scalar keys %ChangedItems && $newsprofiles{$i}->{type} =~ /\AMaginot Static/i ) {
		delete $ActiveProfiles{$i};
	}
END_CODE

my $Rebuild_Static = << 'END_CODE';
	$ChangedItems{$newsid} = 1;
	unless( $CConfig{AutoBuild_Modify} ) {
		&BuildNewsStatic( 0 );
	}
END_CODE

my $Build_Static = << 'END_CODE';
	$ChangedItems{$newsid} = 1;
	unless( $CConfig{AutoBuild_Submit} ) {
		&BuildNewsStatic( 0 );
	}
END_CODE

my $BuildNews_ProfileType = << 'END_CODE';
if( $newsprofiles{$i}->{type} =~ /\AMaginot Static/ ) {
	if( $buildtype || ! $newsprofiles{$i}->{ppautorebuild} || $ChangedItems{$newsid} ) {
		my $k;
		if ($newsprofiles{$i}->{filtsub}) {
			my $tmpnhash = {};
			foreach $k (@fieldDB_internalorder) {
				$tmpnhash->{$k} = ${$k};
			}
			push(@{$FilteredContent{$i}}, $tmpnhash);
		}
		else {
			$ProfileName = $i;
			&Maginot_BuildStatic;
		}
	}
}
elsif( $newsprofiles{$i}->{type} eq 'Maginot Sliced' ) {
	my $k;
	if ($newsprofiles{$i}->{filtsub}) {
		my $tmpnhash = {};
		foreach $k (@fieldDB_internalorder) {
			$tmpnhash->{$k} = ${$k};
		}
		push(@{$FilteredContent{$i}}, $tmpnhash);
	}
	else {
		$ProfileName = $i;
		&Maginot_BuildSliced;
	}
}
END_CODE

$Subs{Maginot_BuildSliced} = << 'END_SUB';
sub Maginot_BuildSliced {
	$PPStaticOpts{$ProfileName}->{newsnum} += 1;
	$SliceField = $PPStaticOpts{$ProfileName}->{SliceField};
	if( exists $PPCustomFields{$SliceField} ) {
		${$SliceField} = &{$PPCustomFields{$SliceField}->[3]};
	}
	$SliceValue = ${$SliceField};
	$PPSlicedIndex{$ProfileName}->{$SliceValue} = 1;
	my $k;
	unless( exists $PPNewsItems{$newsid} ) {
		my $tmpnhash = {};
		foreach $k (@fieldDB_internalorder) {
			$tmpnhash->{$k} = ${$k};
		}
		$PPNewsItems{$newsid} = $tmpnhash;
	}
	push( @{$PPSliced{$ProfileName}->{$SliceValue}}, $newsid );
	unless( exists $PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileName} ) {
		my $FileNamePrefix = $SliceValue;
		$FileNamePrefix =~ s~[^A-Za-z0-9\-\.]~~g;
		$FileNamePrefix = substr( $FileNamePrefix, 0, $PPStaticOpts{$ProfileName}->{maxlength} );
		my $FileNameSuffix = $PPStaticOpts{$ProfileName}->{filext};
		my $FilePath = $newsprofiles{$ProfileName}->{filepath} || $CConfig{htmlfile_path};
		my $FileName = qq~$FileNamePrefix.$FileNameSuffix~;
		$FilePath = &Maginot_MakePath( $FilePath );
		my $FileURL = &Maginot_GetPath($PPStaticOpts{$ProfileName}->{dirurl}) . "/$FileName";
		$PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileName} = $FileName;
		$PPSlicedFiles{$ProfileName}->{$SliceValue}->{FilePrefix} = $FilePrefix;
		$PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileSuffix} = $FileSuffix;
		$PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileURL} = $FileURL;
		$PPSlicedFiles{$ProfileName}->{$SliceValue}->{FilePath} = $FilePath;
	}	
}
END_SUB

my $BuildNewsStatic_Filtered = << 'END_CODE';
	# Static Pages
	my( $i, $j, $k, $n );
	foreach $i (keys %FilteredContent) {
		unless ($newsprofiles{$i}->{filtsub} && $newsprofiles{$i}->{type} eq 'Maginot Static' || $newsprofiles{$i}->{type} eq 'Maginot Static Split') { next; }
		# Run the saved data through the specified sorting subroutine.
		@FilteredND = &{$newsprofiles{$i}->{'filtsub'}}(@{$FilteredContent{$i}});
		$PrevFileName = '';
		$PrevFilePath = '';
		$PrevFileURL = '';
		$ProfileName = $i;
		for( $ProfileIndex = 0; $ProfileIndex < @FilteredND; ++$ProfileIndex ) {
			$j = $FilteredND[$ProfileIndex];
			#
			# This is the lookahead code for getting the next file link..
			#
			if( $ProfileIndex + 1 < scalar @FilteredND ) {
				$n = $FilteredND[$ProfileIndex+1];
				foreach $k (keys %{$n}) {
					${$k} = $n->{$k};
				}
        			$Date = GetTheDate($newstime);
        			$FileNamePrefix = ${$PPStaticOpts{$ProfileName}->{staticfield}};
        			$FileNamePrefix =~ s~[^A-Za-z0-9\-\.]~~g;
        			$FileNamePrefix = substr( $FileNamePrefix, 0, $PPStaticOpts{$ProfileName}->{maxlength} );
        			$FileNameSuffix = $PPStaticOpts{$ProfileName}->{filext};
        			$NextFilePath = $newsprofiles{$ProfileName}->{filepath} || $CConfig{htmlfile_path};
        			$BaseURL = $newsprofiles{$ProfileName}->{ppstaticbaseurl};
        			$DirURL = $newsprofiles{$ProfileName}->{ppstaticdirurl};
        			$NextFileName = qq~$FileNamePrefix.$FileNameSuffix~;
        			$NextFilePath = &Maginot_GetPath($NextFilePath);
        			$NextFileURL = &Maginot_GetPath($DirURL) . "/$NextFileName";
			}
			else {
				$NextFileName = '';
				$NextFilePath = '';
				$NextFileURL = '';
			}
			# The data has been sorted; go through the sorted data.
			# Get the global field variables.
			foreach $k (keys %{$j}) {
				${$k} = $j->{$k};
			}
			# Build HTML, save. As usual.
			&Maginot_BuildStatic;
			$PrevFileName = $FileName;
			$PrevFilePath = $FilePath;
			$PrevFileURL = $FileURL;
		}
		delete $FilteredContent{$i};
	}
	foreach $i (keys %FilteredContent) {
		unless ($newsprofiles{$i}->{type} eq 'Maginot Sliced') { next; }
		# Run the saved data through the specified sorting subroutine.
		@FilteredND = &{$newsprofiles{$i}->{'filtsub'}}(@{$FilteredContent{$i}});
		foreach $j (@FilteredND) {
			# The data has been sorted; go through the sorted data.
			# Get the global field variables.
			foreach $k (keys %{$j}) {
				${$k} = $j->{$k};
			}
			# Build HTML, save. As usual.
			$ProfileName = $i;
			&Maginot_BuildSliced;
		}
		delete $FilteredContent{$i};
	}
	# Sliced Pages
	&Maginot_BuildAllSliced;
END_CODE

#
# Build all sliced profiles
#
$Subs{Maginot_BuildAllSliced} = << 'END_SUB';
sub Maginot_BuildAllSliced {
	my( $profslicevalues, @profslicevalues, $profsliceindex, $newsidlist, $i, $j, $k );
	while( ( $ProfileName, $profslicevalues ) = each(%PPSliced) ) {
		@profslicevalues = sort keys %{$profslicevalues};
		$BaseURL = $newsprofiles{$ProfileName}->{ppstaticbaseurl};
		$DirURL = $newsprofiles{$ProfileName}->{ppstaticdirurl};
		$SliceField = $newsprofiles{$ProfileName}->{ppstaticfield};
		$PrevSliceValue = '';
		$PrevFileName = '';
		$PrevFilePrefix = '';
		$PrevFileSuffix = '';
		$PrevFileURL = '';
		$PrevFilePath = '';
		# For each profile which is sliced...
		# HOOK: BuildNews_SlicedProfile
		if($Addons{'BuildNews_PPSlicedProfile'}){foreach my $i (@{$Addons{'BuildNews_PPSlicedProfile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}	
		for( $profsliceindex = 0; $profsliceindex < scalar @profslicevalues; ++$profsliceindex ) {
			$SliceValue = $profslicevalues[$profsliceindex];
			$newsidlist = $profslicevalues->{$SliceValue};
			${$SliceField} = $SliceValue;
			#
			# Now create the values which will be used by all
			# news items sharing the same slice field value.
			my $HTMLContent;
			$FileName = $PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileName};
			$FilePrefix = $PPSlicedFiles{$ProfileName}->{$SliceValue}->{FilePrefix};
			$FileSuffix = $PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileSuffix};
			$FileURL = $PPSlicedFiles{$ProfileName}->{$SliceValue}->{FileURL};
			$FilePath = $PPSlicedFiles{$ProfileName}->{$SliceValue}->{FilePath};
			if( $profsliceindex + 1 < scalar @profslicevalues ) {
				$NextSliceValue = $profslicevalues[$profsliceindex+1] || '';
				$NextFileName = $PPSlicedFiles{$ProfileName}->{$NextSliceValue}->{FileName};
				$NextFilePrefix = $PPSlicedFiles{$ProfileName}->{$NextSliceValue}->{FilePrefix};
				$NextFileSuffix = $PPSlicedFiles{$ProfileName}->{$NextSliceValue}->{FileSuffix};
				$NextFileURL = $PPSlicedFiles{$ProfileName}->{$NextSliceValue}->{FileURL};
				$NextFilePath = $PPSlicedFiles{$ProfileName}->{$NextSliceValue}->{FilePath};
			}
			else {
				$NextSliceValue = '';
				$NextFileName = '';
				$NextFilePrefix = '';
				$NextFileSuffix = '';
				$NextFileURL = '';
				$NextFilePath = '';
			}
			#
			#
			# Now open the sliced file...
			my $psp = CRopen(">$FilePath/$FileName");
			#
			# HOOK: BuildNews_SlicedProfile_2
			if($Addons{'BuildNews_PPSlicedProfile_2'}){foreach my $i (@{$Addons{'BuildNews_PPSlicedProfile_2'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
			for( $i = 0; $i < @{$newsidlist}; ++$i ) {
				$newsid = $newsidlist->[$i];
				# Get the global field variables.
				foreach $k (keys %{$PPNewsItems{$newsid}}) {
					${$k} = $PPNewsItems{$newsid}->{$k};
				}
				$Date = GetTheDate($newstime);
				#
				# HOOK: BuildNews_SlicedProfile_Loop
				if($Addons{'BuildNews_PPSlicedProfile_Loop'}){foreach my $i (@{$Addons{'BuildNews_PPSlicedProfile_Loop'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
				#
				# Build the HTML and save it in a temporary variable.
				$newshtml = &{$newsprofiles{$ProfileName}->{'style'}};
				# If creating an HTML file, save the info for later.
				if ($newsprofiles{$ProfileName}->{'tmplfile'}) {
					$HTMLContent .= $newshtml;
				}
				else {
					print {$psp} $newshtml;
				}
			}
			# Print news controls or links
			# Process templates or print the plain news style
			if( $newsprofiles{$ProfileName}->{'tmplfile'} ) {
				if ($newsprofiles{$ProfileName}->{'DisplayLink'} == 1) {
					$HTMLContent .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://www.amphibianweb.com" target="_blank">Coranto</a></small></i>$br~;
				}
				elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 2) {
					$HTMLContent .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://coranto.gweilo.org" target="_blank">Coranto</a></small></i>$br~;
				}
				elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 3) {
					$HTMLContent .= qq~$br<i><small>$Messages{'DisplayLink'} Coranto</small></i>$br~;
				}
				print {$psp} ProcessTMPL("$CConfig{'admin_path'}/$newsprofiles{$ProfileName}->{'tmplfile'}", \$HTMLContent, "$newsprofiles{$ProfileName}->{'tmpltitle'} : $slicevalue");
			}
			else {
				if ($newsprofiles{$ProfileName}->{'DisplayLink'} == 1) {
					print {$psp} qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://www.amphibianweb.com" target="_blank">Coranto</a></small></i>$br~;
				}
				elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 2) {
					print {$psp} qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://coranto.gweilo.org" target="_blank">Coranto</a></small></i>$br~;
				}
				elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 3) {
					print {$psp} qq~$br<i><small>$Messages{'DisplayLink'} Coranto</small></i>$br~;
				}
			}
			# HOOK: BuildNewsSliced_CloseFile
			if($Addons{'BuildNewsSliced_CloseFile'}){foreach my $i (@{$Addons{'BuildNewsSliced_CloseFile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
			close( $psp );
			chmod(0666, "$filepath/$FileName");
			$PrevSliceValue = $SliceValue;
			$PrevFileName = $FileName;
			$PrevSlicePrefix = $SlicePrefix;
			$PrevSliceSuffix = $SliceSuffix;
			$PrevFileURL = $FileURL;
			$PrevFilePath = $FilePath;
		}
	}
	&Maginot_BuildSlicedIndices;
}
END_SUB

$Subs{Maginot_BuildSlicedIndices} = << 'END_SUB';
sub Maginot_BuildSlicedIndices {
	foreach my $prof (keys %newsprofiles) {
		if( $newsprofiles{$prof}->{'enabled'} && $newsprofiles{$prof}->{type} eq 'Maginot Sliced Index' ) {
			my $sliceprofile = $newsprofiles{$prof}->{ppsliceprofile};
			if( exists $newsprofiles{$sliceprofile} && $newsprofiles{$sliceprofile}->{type} eq 'Maginot Sliced'
					&& $newsprofiles{$sliceprofile}->{enabled} ) {
				$ProfileName = $prof;
				$FilePath = $newsprofiles{$prof}->{filepath} || $CConfig{htmlfile_path};
				$FileName = $newsprofiles{$prof}->{textfile};
				$FileName =~ m~\A(.*)\.(\w+)\Z~;
				( $FileNamePrefix, $FileNameSuffix ) = ( $1, $2 );
				$BaseURL = $newsprofiles{$ProfileName}->{ppstaticbaseurl};
				$DirURL = $newsprofiles{$ProfileName}->{ppstaticdirurl};
				if( $newsprofiles{$prof}->{tmplfile} ) {
					$FileNameSuffix = $newsprofiles{$prof}->{ppstaticfilext};
					$FileName = "$FileNamePrefix.$FileNameSuffix";
				}
				$SliceField = $newsprofiles{$sliceprofile}->{ppstaticfield};
				$FilePath = &Maginot_MakePath($FilePath);
				$FileURL = &Maginot_GetPath($DirURL) . "/$FileName";
				my $slicevaluehash = $PPSliced{$sliceprofile};
				my @slicevalues = keys %$slicevaluehash;
				if( $newsprofiles{$prof}->{ppslindexsort} eq 'Reverse Alphabetical' ) {
					@slicevalues = sort { $b cmp $a } @slicevalues;
				}
				elsif( $newsprofiles{$prof}->{ppslindexsort} eq 'Numerical' ) {
					@slicevalues = sort { $a <=> $b } @slicevalues;
				}
				elsif( $newsprofiles{$prof}->{ppslindexsort} eq 'Reverse Numerical' ) {
					@slicevalues = sort { $b <=> $a } @slicevalues;
				}
				else {
					@slicevalues = sort { $a cmp $b } @slicevalues;
				}
				my $psp = CRopen(">$FilePath/$FileName");
				foreach $SliceValue (@slicevalues) {
					$LinkName = $PPSlicedFiles{$sliceprofile}->{$SliceValue}->{FileName};
					$LinkNamePrefix = $PPSlicedFiles{$sliceprofile}->{$SliceValue}->{FilePrefix};
					$LinkNameSuffix = $PPSlicedFiles{$sliceprofile}->{$SliceValue}->{FileSuffix};
					$LinkURL = $PPSlicedFiles{$sliceprofile}->{$SliceValue}->{FileURL};
					$LinkPath = $PPSlicedFiles{$sliceprofile}->{$SliceValue}->{FilePath};
					# Build the HTML and save it in a temporary variable.
					$newshtml = &{$newsprofiles{$ProfileName}->{'style'}};
					# If creating an HTML file, save the info for later.
					if ($newsprofiles{$ProfileName}->{'tmplfile'}) {
						$HTMLContent .= $newshtml;
					}
					else {
						print {$psp} $newshtml;
					}
				}
				# Print news controls or links
				# Process templates or print the plain news style
				if( $newsprofiles{$prof}->{'tmplfile'} ) {
					if ($newsprofiles{$prof}->{'DisplayLink'} == 1) {
						$HTMLContent .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://www.amphibianweb.com" target="_blank">Coranto</a></small></i>$br~;
					}
					elsif ($newsprofiles{$prof}->{'DisplayLink'} == 2) {
						$HTMLContent .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://coranto.gweilo.org" target="_blank">Coranto</a></small></i>$br~;
					}
					elsif ($newsprofiles{$prof}->{'DisplayLink'} == 3) {
						$HTMLContent .= qq~$br<i><small>$Messages{'DisplayLink'} Coranto</small></i>$br~;
					}
					print {$psp} ProcessTMPL("$CConfig{'admin_path'}/$newsprofiles{$prof}->{'tmplfile'}", \$HTMLContent, "$newsprofiles{$prof}->{'tmpltitle'}");
				}
				else {
					if ($newsprofiles{$prof}->{'DisplayLink'} == 1) {
						print {$psp} qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://www.amphibianweb.com" target="_blank">Coranto</a></small></i>$br~;
					}
					elsif ($newsprofiles{$prof}->{'DisplayLink'} == 2) {
						print {$psp} qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://coranto.gweilo.org" target="_blank">Coranto</a></small></i>$br~;
					}
					elsif ($newsprofiles{$prof}->{'DisplayLink'} == 3) {
						print {$psp} qq~$br<i><small>$Messages{'DisplayLink'} Coranto</small></i>$br~;
					}
				}
				# HOOK: BuildNewsSliced_CloseFile
				if($Addons{'BuildNewsSliced_CloseFile'}){foreach my $i (@{$Addons{'BuildNewsSliced_CloseFile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
				close( $psp );
				chmod(0666, "$filepath/$FileName");
			}
		}
	}
}
END_SUB

$Subs{Maginot_BuildStatic} = << 'END_SUB';
sub Maginot_BuildStatic {
	$Date = GetTheDate($newstime);
	$StaticField = $PPStaticOpts{$ProfileName}->{staticfield};
	if( exists $PPCustomFields{$StaticField} ) {
		${$StaticField} = &{$PPCustomFields{$StaticField}->[3]};
	}
	$FileNamePrefix = ${$StaticField};
	$FileNamePrefix =~ s~[^A-Za-z0-9\-\.]~~g;
	$FileNamePrefix = substr( $FileNamePrefix, 0, $PPStaticOpts{$ProfileName}->{maxlength} );
	$FileNameSuffix = $PPStaticOpts{$ProfileName}->{filext};
	$FilePath = $newsprofiles{$ProfileName}->{filepath} || $CConfig{htmlfile_path};
	$BaseURL = $newsprofiles{$ProfileName}->{ppstaticbaseurl};
	$DirURL = $newsprofiles{$ProfileName}->{ppstaticdirurl};
	if( $newsprofiles{$ProfileName}->{type} eq 'Maginot Static Split' ) {
		my $splitsubs = $PPStaticOpts{$ProfileName}->{splitsubs};
		my $splittmpl = $PPStaticOpts{$ProfileName}->{splittmpl};
		my @splittext = split( /<pr>/i, $Text );
		@splittitle = ( $Subject );
		$SplitTitle = $Subject;
		for( my $i = 1; $i < @splittext; ++$i ) {
			if( $splittext[$i] =~ s~\A(.*)</pr>~~i ) {
				$SplitTitle = $1;
			}
			push( @splittitle, $SplitTitle );
		}
		my $splitmax = scalar @splittext;
		@SplitPage = ( qq~$FileNamePrefix.$FileNameSuffix~ );
		for( my $i = 2; $i <= @splittext; $i++ ) {
			$SplitPage[$i-1] = "$FileNamePrefix$i.$FileNameSuffix";
		}
		my $splitmiddlesubs = @$splitsubs - 1 ? @$splitsubs - 2 : @$splitsubs - 1;
		my $splitmiddletmpl = scalar @splittmpl == 0 ? 0 : (@$splittmpl - 1 ? @$splittmpl - 2 : @$splittmpl - 1);
		for( $SplitIndex = 0; $SplitIndex < $splitmax; $SplitIndex++ ) {
			$SplitNumber = $SplitIndex + 1;
			$SplitText = $splittext[$SplitIndex];
			$FileName = $SplitPage[$SplitIndex];
			my $splitsub = $$splitsubs[$SplitIndex] || ( $SplitNumber == $splitmax ? $$splitsubs[@$splitsubs-1] : $$splitsubs[$splitmiddlesubs] );
			my $splittmp = $$splittmpl[$SplitIndex] || ( $SplitNumber == $splitmax ? $$splittmpl[@$splittmpl-1] : $$splittmpl[$splitmiddletmpl] );
			$SplitTitle = $splittitle[$SplitIndex] || $splittitle[$#splittitle];
			$PrevSplit = $SplitIndex ? $SplitPage[$SplitIndex-1] : '';
			$NextSplit = $SplitIndex < $splitmax ? $SplitPage[$SplitNumber] : '';
			$splitpagenum = $splitmax - 1 ? qq~ page $SplitNumber~ : q~~;
			$FilePath = &Maginot_MakePath($FilePath);
			$FileURL = &Maginot_GetPath($DirURL) . "/$FileName";
			$newshtml = &{$splitsub};
			# Print news controls or links
			if ($newsprofiles{$ProfileName}->{'DisplayLink'} == 1) {
				$newshtml .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://www.amphibianweb.com" target="_blank">Coranto</a></small></i>$br~;
			}
			elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 2) {
				$newshtml .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://coranto.gweilo.org" target="_blank">Coranto</a></small></i>$br~;
			}
			elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 3) {
				$newshtml .= qq~$br<i><small>$Messages{'DisplayLink'} Coranto</small></i>$br~;
			}
			my $psp = CRopen(">$FilePath/$FileName");
			# Process templates or print the plain news style
			if( $splittmp ) {
				print {$psp} ProcessTMPL("$CConfig{'admin_path'}/$splittmp", \$newshtml, "$newsprofiles{$ProfileName}->{'tmpltitle'} : ${$newsprofiles{$ProfileName}->{'ppstaticfield'}}$splitpagenum");
			}
			else {
				print {$psp} $newshtml;
			}
			# HOOK: BuildNews_CloseFile
			if($Addons{'BuildNews_CloseFile'}){foreach my $i (@{$Addons{'BuildNews_CloseFile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
			close($psp);
			chmod(0666, "$FilePath/$FileName");

		}
		$FileName = $SplitPage[0];	# for referential use after the function if necessary.
	}
	else {
		$FileName = qq~$FileNamePrefix.$FileNameSuffix~;
		$FilePath = &Maginot_MakePath($FilePath);
		$FileURL = &Maginot_GetPath($DirURL) . "/$FileName";
		my $psp = CRopen(">$FilePath/$FileName");
		# HOOK: BuildNews_StaticProfile
		if($Addons{'BuildNews_PPStaticProfile'}){foreach my $i (@{$Addons{'BuildNews_PPStaticProfile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
		$newshtml = &{$newsprofiles{$ProfileName}->{'style'}};
		# Print news controls or links
		if ($newsprofiles{$ProfileName}->{'DisplayLink'} == 1) {
			$newshtml .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://www.amphibianweb.com" target="_blank">Coranto</a></small></i>$br~;
		}
		elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 2) {
			$newshtml .= qq~$br<i><small>$Messages{'DisplayLink'} <a href="http://coranto.gweilo.org" target="_blank">Coranto</a></small></i>$br~;
		}
		elsif ($newsprofiles{$ProfileName}->{'DisplayLink'} == 3) {
			$newshtml .= qq~$br<i><small>$Messages{'DisplayLink'} Coranto</small></i>$br~;
		}
	
		# Process templates or print the plain news style
		if ($newsprofiles{$ProfileName}->{'tmplfile'}) {
			print {$psp} ProcessTMPL("$CConfig{'admin_path'}/$newsprofiles{$ProfileName}->{'tmplfile'}", \$newshtml, "$newsprofiles{$ProfileName}->{'tmpltitle'} : ${$newsprofiles{$ProfileName}->{'ppstaticfield'}} ");
		}
		else {
			print {$psp} $newshtml;
		}
		# HOOK: BuildNews_CloseFile
		if($Addons{'BuildNews_CloseFile'}){foreach my $i (@{$Addons{'BuildNews_CloseFile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
		close($psp);
		chmod(0666, "$FilePath/$FileName");
	}
	$PPStaticOpts{$ProfileName}->{newsnum} += 1;
}
END_SUB

my $StyletoPerl = <<'END_CODE';
	$style =~ s/<MaginotFile: ([a-zA-Z0-9_]+)>/~;\n\$newshtml .= &MaginotFile('$1');\n\$newshtml .= qq~/g;
	$style =~ s/<MaginotURL: ([a-zA-Z0-9_]+)>/~;\n\$newshtml .= &MaginotURL('$1');\n\$newshtml .= qq~/g;
END_CODE

sub MaginotFile {
	my $prof = shift;
	my $f;
	if( exists $PPCustomFields{$PPStaticOpts{$prof}->{staticfield}} ) {
		$f = &{$PPCustomFields{$PPStaticOpts{$prof}->{staticfield}}->[3]};
	}
	else {
		$f = ${$PPStaticOpts{$prof}->{staticfield}};
	}
	$f =~ s~[^A-Za-z0-9\-\.]~~g;
	$f = substr( $f, 0, $PPStaticOpts{$prof}->{maxlength} ) . '.' . $PPStaticOpts{$prof}->{filext};
	return $f;
}

sub MaginotURL {
	my $prof = shift;
	my $f;
	if( exists $PPCustomFields{$PPStaticOpts{$prof}->{staticfield}} ) {
		$f = &{$PPCustomFields{$PPStaticOpts{$prof}->{staticfield}}->[3]};
	}
	else {
		$f = ${$PPStaticOpts{$prof}->{staticfield}};
	}
	$f =~ s~[^A-Za-z0-9\-\.]~~g;
	$f = substr( $f, 0, $PPStaticOpts{$prof}->{maxlength} ) . '.' . $PPStaticOpts{$prof}->{filext};
	$f = &Maginot_GetPath($PPStaticOpts{$prof}->{dirurl}) . "/$f";
	return $f;
}

my $EditNewsStyles_Edit = <<'END_CODE';
	$msg .= q~<hr>Maginot Static adds the following two fields: <b>&lt;MaginotFile: static-profile-name&gt;</b> and <b>&lt;MaginotURL: static-profile-name&gt;</b>. Please see the Maginot Addon's documentation for other useful fields.~;
END_CODE

# Displays settings for a (Maginot Static) profile.
$Subs{'EditProfilePPStatic'} = <<'END_SUB';
sub EditProfilePPStatic {
	my $prof = $in{'profname'};
	&CRHTMLHead(qq~Maginot Static Settings for "$prof"~,1);
	print StartForm( {'profname' => $prof, 'action' => 'admin', 'adminarea' => 'editprofileppstaticsave'} );
	SettingsEngine_Display(EditProfPPStaticDefinition($prof), $newsprofiles{$prof});
	print SubmitButton('Save Settings'), '</form>';
	&CRHTMLFoot;
}
END_SUB

# Saves changes to settings for a (Maginot Static) profile.
$Subs{'EditProfilePPStaticSave'} = <<'END_SUB';
sub EditProfilePPStaticSave {
	my $prof = $in{'profname'};
	CRdie("Invalid profile information") unless ($prof && $newsprofiles{$prof});
	if( $newsprofiles{$prof}->{'type'} =~ /\AMaginot/ ) {
		# Addons: don't assume you're editing a Standard profile here. Other addons may include
		# this hook themselves when editing non-Standard profiles.
		# HOOK: EditProfileSave
		if($Addons{'EditProfileSave'}){foreach my $i (@{$Addons{'EditProfileSave'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
		$newsprofiles{$prof}->{'ForceFullBuild'} = 1;
		SettingsEngine_Save(EditProfPPStaticDefinition($prof), $newsprofiles{$prof});
		WriteProfileInfo();
		SettingsConfirm(PageLink({'action' => 'admin', 'adminarea' => 'profilelist'}) . 'Back to Edit Profiles</a>.');
	}
}
END_SUB

$Subs{'EditProfPPStaticDefinition'} = <<'END_SUB';
sub EditProfPPStaticDefinition {
	my $prof = shift;
	my %DisplayLinkOptions = (
		'0' => 'No link',
		'1' => 'Link pointing to Official Site',
		'2' => 'Link pointing to Unofficial Site',
		'3' => 'Text without link'
	);
	$ProfileName = $prof;
	my $filext = $newsprofiles{$prof}->{'ppstaticfilext'} || $CConfig{'ArcHtmlExt'};
	my $filextlength = length $filext;
	my %fakefields = (
		newstime => 1
	);
	&NeedCFG;
	&Maginot_LoadCustomFields;
	my( %selectedopts, $issel, $sfselect, $arebuild, $nicename, $heightfield );
	if( ! exists $fieldDB{$newsprofiles{$prof}->{'ppstaticfield'}} &&
	! exists $PPCustomFields{$newsprofiles{$prof}->{'ppstaticfield'}} &&
	! exists $fakefields{$newsprofiles{$prof}->{'ppstaticfield'}} ) {
		$newsprofiles{$prof}->{'ppstaticfield'} = 'newsid';
	}
	$heightfield = @fieldDB_internalorder < 10 ? @fieldDB_internalorder : 10;
	foreach $i (@fieldDB_internalorder) {
		$issel = $newsprofiles{$prof}->{'ppstaticfield'} eq $i ? ' selected' : '';
		$nicename = $fieldDB{$i}->{'DisplayName'} || $i;
		$sfselect .= qq~<option value="$i"$issel>$nicename</option>~;
	}
	while( my($key,$val) = each(%PPCustomFields) ) {
		$issel = $newsprofiles{$prof}->{'ppstaticfield'} eq $key ? ' selected' : '';
		$nicename = $val->[0] || $key;
		$sfselect .= qq~<option value="$key"$issel>[$nicename]</option>~;
	}
	my @EditProfileSettings = (
	['heading: Main Profile Settings'],
	['filepath', 'File Path', "The absolute path to the directory in which files will be created, with no trailing slash. <b>Leave blank</b> to use the default HTML Files path (currently $CConfig{'htmlfile_path'})."]
	);
	my @SlicedProfileList;
	my $slidxselect;
	if( $newsprofiles{$prof}->{type} ne 'Maginot Sliced Index' ) {
		push(@EditProfileSettings,
		['agefilter', 'Filter By Time', "The number of days after which news will be considered old. News posted more than the specified number of days ago will not be included in this profile (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by time."],
		['numfilter', 'Filter By Number', "The maximum number of news items that will be included in this profile. For instance, if you set this to 10, then the 11th-newest item will not be included (though it will be archived, if that is enabled). <b>Leave blank</b> if you do not want to filter by number."],
		['skipfilter', 'Skip Items', "If you want to skip news items rather than start with the most recent item, set this to the number of items to be skipped. For instance, if you set this to 3, the first item in this profile will be the 4th-newest. <b>Leave blank</b> if you do not want to skip items."]
		);
	}
	else {
		while( $_ = each(%newsprofiles) ) {
			if( $newsprofiles{$_}->{type} eq 'Maginot Sliced' ) {
				push( @SlicedProfileList, $_ );
				$issel = $newsprofiles{$prof}->{'ppsliceprofile'} eq $_ ? ' selected' : '';
				$slidxselect .= qq~<option value="$_"$issel>$_</option>~;
			}
		}
	}
	push(@EditProfileSettings,
	['ppstaticdirurl', 'Directory URL', "The URL to the directory in which this profile's files shall be written. Enter the URL to <i>$newsprofiles{$prof}->{filepath}</i> or whatever your current File Path is."],
	['ppstaticbaseurl', 'Base URL', "If you wish to refer to another directory from this profile, as in a link, you can fill in this optional field as a convenience!"]
	);
	if( $newsprofiles{$prof}->{type} eq 'Maginot Sliced Index' ) {
		push(@EditProfileSettings,
		['textfile','Text File', 'The filename of the text file to create for this sliced index profile. If you choose to use an HTML template, this name will be used, but the file extension will be replaced with the template-specific file extension.']	
		);
	}
	# Addons: don't assume that you're on the Edit Profile screen for a Standard profile here!
	# New profile types should also incorporate this hook; this is the place to add news-selecting options,
	# like a category selection box. DO NOT add HTML-specific things here; the file being generated may not
	# be HTML!
	# HOOK: EditProfDefinition_1
	if($Addons{'EditProfDefinition_1'}){foreach my $i (@{$Addons{'EditProfDefinition_1'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
	push(@EditProfileSettings, 
	['style', 'News Style', "The news style to use when generating HTML.", GetStyleSelect()],
	['DisplayLink', 'Display Coranto Link', "Adds a link to the Coranto home page to the end of the generated text file. With this version of Coranto, you must include a link on every page of your site that contains news items. If a page contains only headlines that link to full news items, it is exempt from the linking requirement. The default will link to the AmphibianWeb website, which has currently been taken offline. As options, you can choose to link to the unofficial site, or to display the 'Powered by' text with no link, should you not wish to link to a site which is offline.", '<select name="DisplayLink">' . join('', map { qq~<option value="$_"~ . ( $newsprofiles{$prof}->{'DisplayLink'} == $_ ? ' selected' : '' ) . qq~>$DisplayLinkOptions{$_}</option>~ } keys % DisplayLinkOptions) . '</select>'],
	['draw_line'],
	['heading: Advanced Profile Settings'],
	['tmplfile', 'HTML Template', "To use an HTML template when generating static pages, enter the name of a standard .tmpl file below. If you just want the files to contain the plain news style you have selected, then you should leave this blank.</b>.", GetTMPLSelect(1)],
	['tmpltitle', 'HTML File Title', "The title of the generated HTML file. Only necessary if an HTML template has been specified in the previous setting."]
	);
	if( $newsprofiles{$prof}->{type} ne 'Maginot Sliced Index' ) {
		push(@EditProfileSettings,
		['filtsub', 'Filtering', "This should always be Default unless you plan on filtering out certain newsitems (ie filtering by specific word(s) in the Subject, etc). Sort Order is not important to static pages since the news appears one per page.",
			&GetSortOrders ]
		);
	}
	if( $newsprofiles{$prof}->{type} =~ /\AMaginot Static/ ) {
		push(@EditProfileSettings,
		['heading: Maginot Static Page Settings'],
		['ppstaticfield', 'Static Field', "Choose the field to use when determining the file name of the static files. If the specified field is blank, the News ID will be used.",
			qq~<select name="ppstaticfield" size="$heightfield">
			$sfselect
			</select>~]
		);
		while( my($key,$val) = each(%PPCustomFields) ) {
			$nicename = $val->[0] || $key;
			push( @EditProfileSettings, [ "description:$nicename", $nicename, $val->[1], $val->[2] ] );
		}
		push(@EditProfileSettings,
		['ppstaticfilext', 'File Extension', "Choose a file extension to use for all static pages generated by this profile. <b>Leave blank</b> to use the default: <b>$CConfig{'ArcHtmlExt'}</b>"],
		['ppstaticmaxfnlength', 'Maximum File Name Length', "The maximum length of the generated file names, not including the file extension.<br>(currently &quot;$filext&quot; : which is $filextlength characters)"],
		['ppautorebuild', 'Auto-Rebuild', "Choosing this option will ensure that your news is rebuilt as quickly as possible.<br><br>When you submit news, a new file will be created for the new item only. After you modify a news item, only that news item will be rebuilt.",'yn']
		);
	}
	if( $newsprofiles{$prof}->{type} eq 'Maginot Static Split' ) {
		push( @EditProfileSettings,
		['ppsplitsubs', 'Static Split Styles', "Choose Styles to use for pages 2 to the last. If the number of pages is greater than the number of Styles listed here, the second last Style will be used for the remaining pages (except the final page), and the last Style will be used for the final page. <i>Separate the Styles listed here with semicolons.</i>"],
		['ppsplittmpl', 'Static Split Templates', "Choose Templates to use for pages 2 to the last. If the number of pages is greater than the number of Templates listed here, the second last Template will be used for the remaining pages (except the final page), and the last Template will be used for the final page. <i>Separate the Templates listed here with semicolons.</i>"]
		);
	}
	elsif( $newsprofiles{$prof}->{type} eq 'Maginot Sliced' ) {
		push( @EditProfileSettings, 
		['heading: Maginot Sliced Page Settings'],
		['draw_line'],
		['ppstaticfield', 'Slice Field', "Choose the field to use to separate the news items into different files. This field will also be used as the filename. If the specified field is blank, the Subject will be used.",
			qq~<select name="ppstaticfield" size="$heightfield">
			$sfselect
			</select>~]
		);
		while( my($key,$val) = each(%PPCustomFields) ) {
			$nicename = $val->[0] || $key;
			push( @EditProfileSettings, [ "description:$nicename", $nicename, $val->[1], $val->[2] ] );
		}
		push( @EditProfileSettings,
		['draw_line'],
		['ppstaticfilext', 'File Extension', "Choose a file extension to use for all sliced pages generated by this profile. <b>Leave blank</b> to use the default: <b>$CConfig{'ArcHtmlExt'}</b>"],
		['ppstaticmaxfnlength', 'Maximum File Name Length', "The maximum length of the generated file names, not including the file extension.<br>(currently &quot;$filext&quot; : which is $filextlength characters)"]
		);
	}
	elsif( $newsprofiles{$prof}->{type} eq 'Maginot Sliced Index' ) {
		my $slidsortselect;
		my $issel;
		my @choices = ( 'Alphabetical', 'Numerical', 'Reverse Alphabetical', 'Reverse Numerical' );
		$newsprofiles{$prof}->{ppslindexsort} ||= 'Alphabetical';
		foreach (@choices) {
			$issel = $newsprofiles{$prof}->{ppslindexsort} eq $_ ? ' selected' : '';
			$slidsortselect .= qq~<option value="$_"$issel>$_</option>~;
		}
		push( @EditProfileSettings,
		['ppstaticfilext', 'File Extension', "Choose a file extension for the generated page, if you choose to use a template. <b>Leave blank</b> to use the default: <b>$CConfig{'ArcHtmlExt'}</b>"],
		['ppsliceprofile', 'Slice Profile', 'Index the pages of which sliced profile?',
			qq~<select name="ppsliceprofile" size="1">
			$slidxselect
			</select>~],
		['ppslindexsort', 'Sliced Index Sorting', 'Choose the sorting method for the sliced index profile',
			qq~<select name="ppslindexsort" size="4">
			$slidsortselect
			</select>~]
		);
	}
	# HOOK: EditProfDefinition_PPStaticProfile
	if($Addons{'EditProfDefinition_PPStaticProfile'}){foreach my $i (@{$Addons{'EditProfDefinition_PPStaticProfile'}}){my $addon=$i->[2];eval ${$i->[0]};AErr($addon,$@)if $@;};}
	return \@EditProfileSettings;
}
END_SUB

my $ProfileList_NewType_Status = <<'END_CODE';
if( $newsprofiles{$i}->{type} eq 'Maginot Static' || $newsprofiles{$i}->{type} eq 'Maginot Static Split' ) {
	if (!$newsprofiles{$i}->{agefilter} && !$newsprofiles{$i}->{numfilter}) {
		$status .= 'This profile is not filtered by time or number. ';
	}
	else {
		$status .= 'A maximum of ';
		if ($newsprofiles{$i}->{agefilter}) {
			$status .= "<b>$newsprofiles{$i}->{agefilter} days</b> ";
			if ($newsprofiles{$i}->{numfilter}) {
				$status .= ' or ';
			}
		}
		if ($newsprofiles{$i}->{numfilter}) {
			$status .= "<b>$newsprofiles{$i}->{numfilter} items</b> ";
		}
		$status .= 'will be included in this profile. ';
	}
	$status .= qq~Profile type: <b>$newsprofiles{$i}->{type}</b>. ~ if @ProfileTypes;
}
elsif( $newsprofiles{$i}->{type} eq 'Maginot Sliced' ) {
	if (!$newsprofiles{$i}->{agefilter} && !$newsprofiles{$i}->{numfilter}) {
		$status .= 'This profile is not filtered by time or number. ';
	}
	else {
		$status .= 'A maximum of ';
		if ($newsprofiles{$i}->{agefilter}) {
			$status .= "<b>$newsprofiles{$i}->{agefilter} days</b> ";
			if ($newsprofiles{$i}->{numfilter}) {
				$status .= ' or ';
			}
		}
		if ($newsprofiles{$i}->{numfilter}) {
			$status .= "<b>$newsprofiles{$i}->{numfilter} items</b> ";
		}
		$status .= 'will be included in this profile. ';
	}
	my $filext = $newsprofiles{$i}->{filext} || $CConfig{ArcHtmlExt};
	$status .= qq~This profile will be sliced using the field <i>$newsprofiles{$i}->{ppstaticfield}.$filext</i> - ~;
	$status .= qq~Profile type: <b>$newsprofiles{$i}->{type}</b>. ~ if @ProfileTypes;
}
elsif( $newsprofiles{$i}->{type} eq 'Maginot Sliced Index' ) {
	my $filext = $newsprofiles{$i}->{filext} || $CConfig{ArcHtmlExt};
	$status .= qq~This profile will index sliced pages created by the profile $newsprofiles{$i}->{ppslicefield}</i> - ~;
	$status .= qq~Profile type: <b>$newsprofiles{$i}->{type}</b>. ~ if @ProfileTypes;
}
END_CODE

my $ProfileList_NewType_Functions = <<'END_CODE';
if( $newsprofiles{$i}->{'type'} eq 'Maginot Static' ) {
	$actions .= '[' . PageLink( {'action' => 'admin', 'adminarea' => 'editprofileppstatic', 'profname' => $i} ) . 'Edit Maginot Static Settings</a>] ';
}
elsif( $newsprofiles{$i}->{'type'} eq 'Maginot Static Split' ) {
	$actions .= '[' . PageLink( {'action' => 'admin', 'adminarea' => 'editprofileppstatic', 'profname' => $i} ) . 'Edit Maginot Static Split Settings</a>] ';
}
elsif( $newsprofiles{$i}->{'type'} eq 'Maginot Sliced' ) {
	$actions .= '[' . PageLink( {'action' => 'admin', 'adminarea' => 'editprofileppstatic', 'profname' => $i} ) . 'Edit Maginot Sliced Settings</a>] ';
}
elsif( $newsprofiles{$i}->{'type'} eq 'Maginot Sliced Index' ) {
	$actions .= '[' . PageLink( {'action' => 'admin', 'adminarea' => 'editprofileppstatic', 'profname' => $i} ) . 'Edit Maginot Sliced Index Settings</a>] ';
}
END_CODE

my $AddProfile_NewType = <<'END_CODE';
if( $proftype eq 'Maginot Static' ) {
	$newsprofiles{$prof} = { 'enabled' => 0,
	'cats' => ['AllCategories'],
	'agefilter' => '',
	'numfilter' => '',
	'style' => 'NewsStyle_Default',
	'filepath' => '',
	'DisplayLink' => 1,
	'type' => 'Maginot Static',
	'ppstaticfield' => 'newsid',
	'ppstaticbaseurl' => '',
	'ppstaticdirurl' => '',
	'ppautorebuild' => 1,
	'ppstaticfilext' => 'html',
	'ppstaticdirurl' => '',
	'ppstaticmaxfnlength' => 26 };
}
elsif( $proftype eq 'Maginot Static Split' ) {
	$newsprofiles{$prof} = { 'enabled' => 0,
	'cats' => ['AllCategories'],
	'agefilter' => '',
	'numfilter' => '',
	'style' => 'NewsStyle_Default',
	'filepath' => '',
	'DisplayLink' => 1,
	'type' => 'Maginot Static Split',
	'ppstaticfield' => 'newsid',
	'ppstaticbaseurl' => '',
	'ppstaticdirurl' => '',
	'ppautorebuild' => 1,
	'ppstaticfilext' => 'html',
	'ppstaticdirurl' => '',
	'ppstaticmaxfnlength' => 26,
	'ppsplitsubs' => '',
	'ppsplittmpl' => '' };
}
elsif( $proftype eq 'Maginot Sliced' ) {
	$newsprofiles{$prof} = { 'enabled' => 0,
	'cats' => ['AllCategories'],
	'agefilter' => '',
	'numfilter' => '',
	'style' => 'NewsStyle_Default',
	'filepath' => '',
	'DisplayLink' => 1,
	'type' => 'Maginot Sliced',
	'ppstaticfield' => 'Subject',
	'ppstaticbaseurl' => '',
	'ppstaticdirurl' => '',
	'ppstaticfilext' => 'html',
	'ppstaticdirurl' => '',
	'ppstaticmaxfnlength' => 26 };
}
elsif( $proftype eq 'Maginot Sliced Index' ) {
	$newsprofiles{$prof} = { 'enabled' => 0,
	'textfile' => "$prof.txt",
	'style' => 'NewsStyle_Default',
	'filepath' => '',
	'DisplayLink' => 1,
	'type' => 'Maginot Sliced Index',
	'ppsliceprofile' => '',
	'ppslindexsort' => 'Alphabetical',
	'ppstaticbaseurl' => '',
	'ppstaticdirurl' => '',
	'ppstaticfilext' => 'html',
	'ppstaticdirurl' => '',
	'ppstaticmaxfnlength' => 26 };
}
END_CODE

$addon->hook('ProfileList_NewType_Status', \$ProfileList_NewType_Status);
$addon->hook('AddProfile_NewType', \$AddProfile_NewType);
$addon->hook('ProfileList_NewType_Functions', \$ProfileList_NewType_Functions);
$addon->hook('InitActiveProfiles', 'Maginot_InitActiveProfiles');
$addon->hook('InitActiveProfiles_2', \$InitActiveProfiles_2 );
$addon->hook('BuildNews_ProfileType', \$BuildNews_ProfileType);
$addon->hook('StyletoPerl', \$StyletoPerl, 5);
$addon->hook('EditNewsStyles_Edit', \$EditNewsStyles_Edit, 5);
$addon->hook('ModifyNews_EditSave_3', \$Rebuild_Static, -5);
$addon->hook('SaveNews_2', \$Build_Static, -5);
$addon->hook('BuildNews_PostLoop', \$BuildNewsStatic_Filtered, -5);
1;

__END__

=head1 Maginot Line

=head2 BASIC USAGE

After enabling the addon, go to the Edit News Profiles page of the Administration section and create a new profile. Set the profile's type to 'Maginot Static.'

There are several options which can be set for a 'Maginot Static Profile.'
Among them are:

=over 4

=item *

static field: allows you to choose which news field to use to generate a file name for each news item. if none is selected, the newsid is the default. (the newsid is a random string of letters)

=item *

maximum file name length: allows you to limit the maximum length of a file name

=item *

file extension: you can choose any file extension you wish. if none is selected, the Archive HTML file extension from the advanced settings will be used.

=item *

directory URL: the full URL to the directory where the static files will be stored. this is useful when linking to the files from another profile

=item *

auto-rebuild: when checked, this option will not rebuild static pages unless they have been modified. this saves time during normal builds.

=back

=head2 LINKING

To link a Standard profile's news item to the individual page for that news item in a Maginot Static profile, use these two tags:

=over 4

=item *

<MaginotFile: static-profile-name>

=item *

<MaginotURL: static-profile-name>

=back

MaginotURL is the full URL to the news item's file. MaginotFile is the name of the file only. Assuming that you have a Maginot Static profile named Ziggy, you would use the tags like this (capitalization counts):

=over 4

=item *

<MaginotFile: Ziggy> becomes TheSubject.html

=item *

<MaginotURL: Ziggy> becomes http://my.site.com/TheSubject.html

=back

=head2 EXAMPLE

=over 4

=item *

<a href="http://myserver.com/path/to/staticfiles/<MaginotFile: Ziggy>"><Field: Subject></a>

=item *

<a href="<MaginotURL: Ziggy>"><Field: Subject></a>

=back

=head2 STATIC PAGES

Static pages are the simplest Maginot profile you can make. Each news item is built to its own single file.

=head3 Fields

There are several fields you may use in your News Style pertaining to normal Static Pages. These fields are also relevant for Static Split Pages:

=over 4

=item *

<Field: ProfileIndex> : the index of the current item in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=item *

<Field: PrevFileName> : the name of the previous file in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=item *

<Field: PrevFilePath> : the path of the previous file's directory in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=item *

<Field: PrevFileURL> : the URL of the previous file in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=item *

<Field: NextFileName> : the name of the next file in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=item *

<Field: NextFilePath> : the path of the next file's directory in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=item *

<Field: NextFileURL> : the URL of the next file in the profile.
Only set if you use something other than the default filter. NOT USEFUL IF AUTO-BUILD IS ON.

=back

=head2 STATIC SPLIT PAGES

Static Split pages are static pages which are divided up into several files for just one news item. This means that you can have a long news story spanning several files with a <<<prev and next>>> link on each one. You determine where the news text is split by putting <PR> tags in the news text field to indicate the desired page boundaries.

=head3 Fields

There are several fields you may use in your News Style pertaining to Static Split Pages:

=over 4

=item *

<Field: PrevSplit> : file name of the previous page. (blank if you're on the first page)

=item *

<Field: NextSplit> : file name of the next page. (blank if you're on the last page)

=item *

<Field: SplitNumber> : the number of the current page. the first page has a SplitNumber of 1.

=item *

<Field: SplitIndex> : the index of the current page. the first page has a SplitIndex of 0.

=item *

<Field: SplitTitle> : the title of the current page...specified using <pr>PAGE TITLE</pr> instead of just <pr>

=item *

<Field: SplitText> : the text that should go on the current page. DO NOT use <Field: Text> because this will return the entire news text, which is not what you want if you're making a Static Split News Style.

=item *

$FileNamePrefix, $FileNameSuffix, @SplitPage : these three are available but not as useful; respectively: the file name prefix, file name suffix, and an array containing the names of all the files for the current news item. (for expert users only)

=back

=head2 SLICED PAGES

Sliced profiles are like static pages except that every news item sharing the same specified "slice field" is placed in the same file. For example, if you have a sliced profile by "Subject" then all news items with the subject "Cool" are placed in the file "cool.html"

=head3 Fields

=over 4

=item *

<Field: SliceField> : the name of the field used to separate the news items. eg: Subject

=item *

<Field: SliceValue> : the current value of the field used to separate the news items. eg: "Cool"

=back

=head2 SLICED INDEX PAGES

A sliced index profile exists to list all the files which were generated by a sliced profile. You can only list the files from a single sliced profile in a sliced index profile.

=head3 Fields

=over 4

=item *

<Field: SliceField> : the name of the field used to separate the news items. eg: Subject

=item *

<Field: SliceValue> : the current value of the field used to separate the news items. eg: "Cool"

=item *

<Field: LinkName> : the filename linked to by this profile.

=item *

<Field: LinkNamePrefix> : the filename linked to, without the extension.

=item *

<Field: LinkNameSuffix> : the extension of the file linked to by this profile.

=item *

<Field: LinkPath> : the path to the file linked to by this profile.

=item *

<Field: LinkName> : the URL of the file linked to by this profile.

=back

=head3 Examples

=over 4

=begin html

&lt;If: Field: PrevSplit&gt;<br>
&lt;a href=&quot;&lt;Field: PrevSplit&gt;&quot;&gt;&amp;lt;&amp;lt;&amp;lt;prev&lt;/a&gt;<br>
&lt;/If&gt;<br>
<br>
&lt;If: Field: NextSplit&gt;<br>
&lt;a href=&quot;&lt;Field: NextSplit&gt;&quot;&gt;next&amp;gt;&amp;gt;&amp;gt;&lt;/a&gt;<br>
&lt;/If&gt;<br>

=end html

=back

=head2 Runtime specified directory paths

In Maginot Line build 9 and above, you may now specify directory paths using the <Field: FieldName> syntax of Coranto's news style editor. Be aware that if you do this, you must also include the special <Field:> tags in the directory URL field.

=head3 Example:

=over 4

=item *

File Path: /home/username/public_html/news/<Field: Subject>

=item *

Directory URL: http://www.mysite.com/news/<Field: Subject>

=back

=head2 ABOUT THE AUTHOR

=over 4

=item *

name: plushpuffin

=item *

email: plushpuffin@wwddfd.com

=item *

site: http://www.wwddfd.com/

=back

=head2 Other info

The following fields apply to all Maginot Line profiles:

=over 4

=item *

ProfileName : the name of the current profile

=item *

FileNamePrefix : the filename without the extension

=item *

FileNameSuffix : the extension currently being used

=item *

FileName : the full filename

=item *

FilePath : the directory path in which the current profile's files are stored

=item *

FileURL : the full file URL

=item *

DirURL : the URL of the directory in which this profile's files are stored

=item *

BaseURL : the base URL of the profile

=back

=head2 I like pie.